using System;
using Server;
using Server.Items;

namespace Server
{
	public class LevelItems
	{
		//These are the definable features for item leveling...
        public static readonly int DefaultMaxLevel = 20; //Default Max level for items.
        public static readonly int MaxLevelsCap = 100; //Number of total levels items can go up to when maxed.
        public static readonly int MaxLevelsArtifactCap = 150; //Number of total levels artifacts can go up to when maxed.
        public static readonly bool EnableExpCap = true; //true = Cap experience per level.  false = no cap.
        public static readonly bool DisplayExpProp = true; //true = Display experience on item onmouseover/click.

        //These are the definable features for spending points...
        public static readonly int PointsPerLevel = 5; //How many spending points an item gets per level. defaul 5
        public static readonly bool DoubleArtifactCost = true; //true = Artifact attributes will cost double points.

        //These are the definable features for Level Increasing...
        public const bool BlacksmithOnly = false; //true = May only be used by char with blacksmithy.
        public const double BlacksmithSkillRequired = 100; // Amount of Blacksmith skill required to validate deeds (if BlacksmithOnly is true).
        public const bool RewardBlacksmith = true; //true = give the blacksmith reward for validating (if BlacksmithOnly is true).
        public const int BlacksmithRewardAmt = 500; // Amount to pay blacksmith if they validate deed for another player (if BlacksmithOnly and RewardBlacksmith are true).
        
        public static int GetMaxLevelsCap( Item item )
        {
            if ( item is BaseWeapon && ((BaseWeapon)item).ArtifactRarity > 0 )
               return LevelItems.MaxLevelsArtifactCap;
               
            else if ( item is BaseArmor && ((BaseArmor)item).ArtifactRarity > 0 )
               return LevelItems.MaxLevelsArtifactCap;
               
            else if ( item is BaseJewel && ((BaseJewel)item).ArtifactRarity > 0 )
               return LevelItems.MaxLevelsArtifactCap;
               
            else if ( item is BaseClothing && ((BaseClothing)item).ArtifactRarity > 0 )
               return LevelItems.MaxLevelsArtifactCap;
               
            else            
               return LevelItems.MaxLevelsCap;
        }
	}
}